
// PTsampleDlg.cpp : t@C
//

#include "stdafx.h"
#include "PTsample.h"
#include "PTsampleDlg.h"
#include "SelportDlg.h"
#include "PtButton.h"

#include "ptzApi.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// AvP[Ṽo[WɎg CAboutDlg _CAO

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// _CAO f[^
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV T|[g

// 
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CPTsampleDlg _CAO

int	IDs[] = {	IDC_DISCON,
				IDC_UPLEFT, IDC_UP, IDC_UPRIGHT, IDC_LEFT,
				IDC_RIGHT, IDC_DOWNLEFT, IDC_DOWN, IDC_DOWNRIGHT,
				IDC_SL_PAN_SPEED, IDC_SL_TILT_SPEED, IDC_GET_PT_POS,
				-1 };



CPTsampleDlg::CPTsampleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPTsampleDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CPTsampleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_SL_PAN_SPEED, m_slPanSpd);
	DDX_Control(pDX, IDC_SL_TILT_SPEED, m_slTiltSpd);
}

BEGIN_MESSAGE_MAP(CPTsampleDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_CON, &CPTsampleDlg::OnBnClickedCon)
	ON_BN_CLICKED(IDC_DISCON, &CPTsampleDlg::OnBnClickedDiscon)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SL_PAN_SPEED, &CPTsampleDlg::OnNMReleasedcaptureSlPanSpeed)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SL_TILT_SPEED, &CPTsampleDlg::OnNMReleasedcaptureSlTiltSpeed)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_GET_PT_POS, &CPTsampleDlg::OnBnClickedGetPtPos)
END_MESSAGE_MAP()


// CPTsampleDlg bZ[W nh

BOOL CPTsampleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// "o[W..." j[VXe j[ɒǉ܂B

	// IDM_ABOUTBOX ́AVXe R}h͈͓̔ɂȂ΂Ȃ܂B
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// ̃_CAÕACRݒ肵܂BAvP[ṼC EBhE_CAOłȂꍇA
	//  Framework ́A̐ݒIɍs܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACR̐ݒ
	SetIcon(m_hIcon, FALSE);		// ACR̐ݒ

	// TODO: ɒǉ܂B
	m_UpButton = new CPtButton(IDC_UP);
	m_UpButton->SubclassDlgItem(IDC_UP, this);

	m_UpRightButton = new CPtButton(IDC_UPRIGHT);
	m_UpRightButton->SubclassDlgItem(IDC_UPRIGHT, this);

	m_UpLeftButton = new CPtButton(IDC_UPLEFT);
	m_UpLeftButton->SubclassDlgItem(IDC_UPLEFT, this);

	m_DownButton = new CPtButton(IDC_DOWN);
	m_DownButton->SubclassDlgItem(IDC_DOWN, this);

	m_DownRightButton = new CPtButton(IDC_DOWNRIGHT);
	m_DownRightButton->SubclassDlgItem(IDC_DOWNRIGHT, this);

	m_DownLeftButton = new CPtButton(IDC_DOWNLEFT);
	m_DownLeftButton->SubclassDlgItem(IDC_DOWNLEFT, this);

	m_RightButton = new CPtButton(IDC_RIGHT);
	m_RightButton->SubclassDlgItem(IDC_RIGHT, this);

	m_LeftButton = new CPtButton(IDC_LEFT);
	m_LeftButton->SubclassDlgItem(IDC_LEFT, this);

	m_slPanSpd.SetRange(1, 4);
	m_slPanSpd.SetTicFreq(1);

	m_slTiltSpd.SetRange(1, 4);
	m_slTiltSpd.SetTicFreq(1);

	return TRUE;  // tH[JXRg[ɐݒ肵ꍇATRUE Ԃ܂B
}

void CPTsampleDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// _CAOɍŏ{^ǉꍇAACR`悷邽߂
//  ̃R[hKvłBhLg/r[ fg MFC AvP[V̏ꍇA
//  ́AFramework ɂĎIɐݒ肳܂B

void CPTsampleDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// NCAg̎lp`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR̕`
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// [U[ŏEBhEhbOĂƂɕ\J[\擾邽߂ɁA
//  VXe̊֐Ăяo܂B
HCURSOR CPTsampleDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

BOOL CPTsampleDlg::SetCurrent()
{
	int speed;
	if ( PTZ_SUCCESS != PTZ_GetMotorSpeed(PTZ_MOTOR_PAN, &speed) ) {
		return FALSE;
	}
	m_slPanSpd.SetPos(speed);
	
	if ( PTZ_SUCCESS != PTZ_GetMotorSpeed(PTZ_MOTOR_TILT, &speed) ) {
		return FALSE;
	}
	m_slTiltSpd.SetPos(speed);

	return TRUE;
}

void CPTsampleDlg::OnBnClickedCon()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	CSelportDlg dlg;
	
	if ( IDCANCEL == dlg.DoModal() ) {
		return;
	}

	if ( SetCurrent() == FALSE ) {
		MessageBox("܂");
		PTZ_DevClose();
		return;
	}

	for ( int i = 0 ; IDs[i] != -1 ; i++ ) {
		GetDlgItem(IDs[i])->EnableWindow(TRUE);
	}

	GetDlgItem(IDC_CON)->EnableWindow(FALSE);
}

void CPTsampleDlg::OnBnClickedDiscon()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	PTZ_DevClose();

	for ( int i = 0 ; IDs[i] != -1 ; i++ ) {
		GetDlgItem(IDs[i])->EnableWindow(FALSE);
	}

	GetDlgItem(IDC_CON)->EnableWindow(TRUE);
}

void CPTsampleDlg::OnNMReleasedcaptureSlPanSpeed(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	*pResult = 0;

	PTZ_SetMotorSpeed(PTZ_MOTOR_PAN, m_slPanSpd.GetPos());
}

void CPTsampleDlg::OnNMReleasedcaptureSlTiltSpeed(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	*pResult = 0;

	PTZ_SetMotorSpeed(PTZ_MOTOR_TILT, m_slTiltSpd.GetPos());
}

void CPTsampleDlg::OnDestroy()
{
	CDialog::OnDestroy();

	// TODO: ɃbZ[W nh R[hǉ܂B
	delete m_UpButton;
	delete m_UpRightButton;
	delete m_UpLeftButton;
	delete m_DownButton;
	delete m_DownRightButton;
	delete m_DownLeftButton;
	delete m_RightButton;
	delete m_LeftButton;
}

void CPTsampleDlg::OnBnClickedGetPtPos()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	char	buf[16];
	int		pan_pos, tilt_pos;
	float	f_pan_pos, f_tilt_pos;
	
	if ( PTZ_GetPTPos(&pan_pos, &tilt_pos) != PTZ_SUCCESS ) {
		MessageBox("R}hMG[");
		return;
	}
	
	f_pan_pos = pan_pos;
	f_pan_pos /= 100;
	sprintf(buf, "%.2f", f_pan_pos);
	GetDlgItem(IDC_GET_POS_PAN)->SetWindowTextA(buf);
	
	f_tilt_pos = tilt_pos;
	f_tilt_pos /= 100;
	sprintf(buf, "%.2f", f_tilt_pos);
	GetDlgItem(IDC_GET_POS_TILT)->SetWindowTextA(buf);
}
